/*++   

INTEL CONFIDENTIAL
Copyright 2005-2015 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents
related to the source code ("Material") are owned by Intel Corporation
or its suppliers or licensors. Title to the Material remains with
Intel Corporation or its suppliers and licensors. The Material
contains trade secrets and proprietary and confidential information of
Intel or its suppliers and licensors. The Material is protected by
worldwide copyright and trade secret laws and treaty provisions. No
part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in
any way without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other
intellectual property right is granted to or conferred upon you by
disclosure or delivery of the Materials, either expressly, by
implication, inducement, estoppel or otherwise. Any license under such
intellectual property rights must be express and approved by Intel in
writing.

--*/
                               
/* #EIS_Comment_Tag_Tool *                                 
********************************************************************************
**
**    @file build.h
**
**    @brief Contains the global version strings
**
**    @author Atar Kfir
**
********************************************************************************
*/   

/* Sentry Header
 *******************/
#ifndef _BUILD_H_
#define _BUILD_H_

#ifdef __cplusplus
extern "C" {
#endif


#ifndef VER_BUILD // defined in Camke flags from QB params

/* Global Declarations
 **************************/

/** Build Version Number.  Updated by Jamin */
#define VER_BUILD          3425
/** Build Version String.  Updated by Jamin */
#define VER_BUILD_STR     "3425"

#endif

#ifdef __cplusplus
}
#endif

// WARNING!! DANGER!!
// Right now in KBL, the PV bit value is influenced by a build-time flag, that eventually causes either PV_BIT_SET or PV_BIT_CLEAR to be defined (not both!).
// The build flag can be seen in build.bat, the -D macro definition happens in CmakeLists.txt
// PROBLEM: some components do NOT inherit macro definitions from CmakeLists.txt and therefore will evaluate the expression below, #if defined(PV_BIT_SET), as false always.
// Current known components: Data store and kernel.
// NOTE: if you include this file (build.h) and your component behaves like this, you may experience sever bugs if you use the PV bit value. 

#if defined(PV_BIT_SET)  && ((SLIM_SKU == 1) || (CONSUMER_SKU == 1) || (CORPORATE_SKU == 1))

#define POST_PV   1  // Set this flag to zero when are at PRE-PV and 1 when we are at POST_PV
                     // This flag will take care of including or excluding WW kill-pill check
                     // and turn on the update logic to prevent downgrade from POST_PV to PRE_PV.
                     // To update the PV value in the manifest, please modify the 
                     // XML path /CseConfiguration/CseRegion/ManifestFlags value (bit 0) in the
                     // FTOOL configuration file.

/*** Global Functions
 **************************/
#else

#define POST_PV   0

#endif

#endif // _BUILD_H_

